/*

	setup.S		Copyright (C) 1991, 1992 Linus Torvalds

 setup.s is responsible for getting the system data from the BIOS,
 and putting them into the appropriate places in system memory.
 both setup.s and system has been loaded by the bootblock.

 This code asks the bios for memory/disk/other parameters, and
 puts them in a "safe" place: 0x90000-0x901FF, ie where the
 boot-block used to be. It is then up to the protected mode
 system to read them from there before the area is overwritten
 for buffer-blocks.

 Move PS/2 aux init code to psaux.c
 (troyer@saifr00.cfsat.Honeywell.COM) 03Oct92

 some changes and additional features by Christoph Niemann,
 March 1993/June 1994 (Christoph.Niemann@linux.org)

 add APM BIOS checking by Stephen Rothwell, May 1994
 (Stephen.Rothwell@canb.auug.org.au)

 High load stuff, initrd support and position independency
 by Hans Lermen & Werner Almesberger, February 1996
 <lermen@elserv.ffm.fgan.de>, <almesber@lrc.epfl.ch>

 Video handling moved to video.S by Martin Mares, March 1996
 <mj@k332.feld.cvut.cz>

 Extended memory detection scheme retwiddled by orc@pell.chi.il.us (david
 parsons) to avoid loadlin confusion, July 1997

 July 1999
  Rewrited for GNU as by Yann Droneaud <lch@multimania.com>
	
*/
	

#define __ASSEMBLY__
#include <linux/config.h>
#include <asm/segment.h>
#include <linux/version.h>
#include <linux/compile.h>
#include <asm/boot.h>

/* Signature words to ensure LILO loaded us right */
#define SIG1	0xAA55
#define SIG2	0x5A5A

#define INITSEG		DEF_INITSEG	/* 0x9000, we move boot here - out of the way */
#define SYSSEG		DEF_SYSSEG	/* 0x1000, system loaded at 0x10000 (65536). */
#define SETUPSEG	DEF_SETUPSEG	/* 0x9020, this is the current segment */
					/*... and the former contents of CS */
#define DELTA_INITSEG   (SETUPSEG - INITSEG) /* 0x0020 */


	.file   "setup.S"
	
	.text

        /* Tell GAS to generate 16-bit instructions so that this code works in real mode. */
        .code16
	 
#if 0	
.globl begtext, begdata, begbss, endtext, enddata, endbss
.text
begtext:
.data
begdata:
.bss
begbss:
.text
#endif
	
.global _start
_start:
	jmp	start_of_setup
/* ------------------------ start of header --------------------------------
 * 
 * SETUP-header, must start at CS:2 (old 0x9020:2)
 */
		.ascii	"HdrS"		/* Signature for SETUP-header */
		.word	0x0201		/* Version number of header format 
					   (must be >= 0x0105
					   else old loadlin-1.5 will fail) */
realmode_swtch:	.word	0,0		/* default_switch,SETUPSEG */
start_sys_seg:	.word	SYSSEG
		.word	kernel_version	/* pointing to kernel version string */
  /* note: above part of header is compatible with loadlin-1.5 (header v1.5),
   *       must not change it
   */
type_of_loader:	.byte	0		/* 
					   = 0, old one (LILO, Loadlin,
					   Bootlin, SYSLX, bootsect...)
					   else it is set by the loader:
					   0xTV: T=0 for LILO
					   T=1 for Loadlin
					   T=2 for bootsect-loader
					   T=3 for SYSLX
					   T=4 for ETHERBOOT
					   V = version
					*/
loadflags:				/* flags, unused bits must be zero (RFU) */
#define LOADED_HIGH 1			/* bit within loadflags,
				           if set, then the kernel is loaded high */
#define CAN_USE_HEAP 0x80		/* if set, the loader also has set heap_end_ptr
					   to tell how much space behind setup.S
					   can be used for heap purposes.
					   Only the loader knows what is free! */
#ifndef __BIG_KERNEL__
		.byte	0x00
#else
		.byte	LOADED_HIGH
#endif

setup_move_size: .word  0x8000		/* size to move, when we (setup) are not
					   loaded at 0x90000. We will move ourselves
					   to 0x90000 then just before jumping into
					   the kernel. However, only the loader
					   know how much of data behind us also needs
					   to be loaded. */
code32_start:				/* here loaders can put a different
					   start address for 32-bit code. */
#ifndef __BIG_KERNEL__
.long	0x1000				/* 0x1000 = default for zImage */
#else
.long	0x100000			/* 0x100000 = default for big kernel */
#endif
ramdisk_image:	.long	0		/* address of loaded ramdisk image
					   Here the loader (or kernel generator) puts
					   the 32-bit address were it loaded the image.
					   This only will be interpreted by the kernel. */
ramdisk_size:	.long	0		/* its size in bytes */
bootsect_kludge:
		.word   bootsect_helper,SETUPSEG
heap_end_ptr:	.word	modelist+1024	/* space from here (exclusive) down to
					   end of setup code can be used by setup
					   for local heap purposes. */
/* ------------------------ end of header ---------------------------------- */

start_of_setup:
/* Bootlin depends on this being done early */
	movw	$0x01500,%ax
	movb	$0x81,%dl
	int	$0x13

#ifdef SAFE_RESET_DISK_CONTROLLER
/* Reset the disk controller. */
	xorw	%ax,%ax
	movb	$0x80,%dl
	int	$0x13
#endif

/* set DS=CS, we know that SETUPSEG == CS at this point */
	movw	%cs,%ax			/* aka #SETUPSEG */
	movw	%ax,%ds

/* Check signature at end of setup */
	cmpw	$SIG1,setup_sig1
	jne	bad_sig
	cmpw	$SIG2,setup_sig2
	jne	bad_sig
	jmp	good_sig1

/* Routine to print ASCIIz string at DS:SI */

prtstr:	lodsb
	andb	%al,%al
	jz	fin
	call 	prtchr
	jmp	prtstr
fin:	retw

/* Space printing */

prtsp2:	call	prtspc			/* Print double space */
prtspc:	movb	$' ',%al		/* Print single space (fall-thru!) */

/* Part of above routine, this one just prints ASCII al */

prtchr:	pushw	%ax
	pushw	%cx
	xorb	%bh,%bh
	movw	$0x01,%cx
	movb	$0x0e,%ah
	int	$0x10
	popw	%cx
	popw	%ax
	retw

beep:	movb	$0x07,%al
	jmp	prtchr
	
no_sig_mess:	.asciz	"No setup signature found ..."

good_sig1:
	jmp	good_sig

/* We now have to find the rest of the setup code/data */
bad_sig:
	movw	%cs,%ax			/* aka #SETUPSEG */
	subw	$DELTA_INITSEG,%ax	/* aka #INITSEG */
	movw	%ax,%ds
	xorb	%bh,%bh
	movb	497,%bl			/* get setup sects from boot sector */
	subw	$4,%bx			/* LILO loads 4 sectors of setup */
	shlw	$8,%bx			/* convert to words */
	movw	%bx,%cx
	shrw	$3,%bx			/* convert to segment */
	addw	$SYSSEG,%bx
	/* seg cs */
	movw	%bx,%cs:start_sys_seg

/* Move rest of setup code/data to here */
	movw	$2048,%di		/* four sectors loaded by LILO */
	subw	%si,%si			/* XXX xorw %si,%si */
	movw	%cs,%ax			/* aka #SETUPSEG */
	movw	%ax,%es
	movw	$SYSSEG,%ax
	movw	%ax,%ds
	rep
	movsw

	movw	%cs,%ax			/* aka #SETUPSEG */
	movw	%ax,%ds
	cmpw	$SIG1,setup_sig1
	jne	no_sig
	cmpw	$SIG2,setup_sig2
	jne	no_sig
	jmp	good_sig

no_sig:
	leaw	no_sig_mess,%si
	call	prtstr
no_sig_loop:
	jmp	no_sig_loop

good_sig:
	movw	%cs,%ax			/* aka #SETUPSEG */
	subw	$DELTA_INITSEG,%ax	/* aka #INITSEG */
	movw	%ax,%ds

	/* check if an old loader tries to load a big-kernel */
	/* seg cs */
	testb	$LOADED_HIGH,%cs:loadflags /* Have we a big kernel? */
	jz	loader_ok		/* NO, no danger even for old loaders
					   YES, we have a big-kernel */
	/* seg cs */
	cmpb	$0,%cs:type_of_loader	/* Have we one of the new loaders? */
	jnz	loader_ok		/* YES, OK
				           NO, we have an old loader, must give up */
	pushw   %cs
	popw	%ds
	leaw	loader_panic_mess,%si
	call	prtstr
	jmp	no_sig_loop
loader_panic_mess: 
	.asciz	"Wrong loader! Giving up."

loader_ok:
/* Get memory size (extended mem, kB) */

#ifndef STANDARD_MEMORY_BIOS_CALL
	pushl	%ebx

        xorl    %ebx,%ebx		/* preload new memory slot with 0k */
        movl	%ebx,0x000001e0

        movw    $0xe801,%ax
	int     $0x15
	jc      oldstylemem

/* Memory size is in 1 k chunksizes, to avoid confusing loadlin.
   We store the 0xe801 memory size in a completely different place,
   because it will most likely be longer than 16 bits.
   (use 1e0 because that's what Larry Augustine uses in his
   alternative new memory detection scheme, and it's sensible
   to write everything into the same place.)
*/
	andl    $0xffff,%ebx		/* clear sign extend */
	shll    $6,%ebx			/* and go from 64k to 1k chunks */
	movl    %ebx,0x000001e0		/* store extended memory size */

	andl    $0xffff,%eax		/* clear sign extend */
 	addl    %eax,0x000001e0		/* and add lower memory into total size. */
  
	/* and fall into the old memory detection code to populate the
	   compatibility slot. */

oldstylemem:
	popl	%ebx
#else
	movl    $0,0x000001e0
#endif
	movb	$0x88,%ah
	int	$0x15
	movw	%ax,2

/* Set the keyboard repeat rate to the max */

	movw	$0x0305,%ax
	xorw	%bx,%bx			/* clear bx */
	int	$0x16

/* Check for video adapter and its parameters and allow the
   user to browse video modes. */

	call	video			/* NOTE: we need DS pointing to boot sector */

/* Get hd0 data */

	xorw	%ax,%ax			/* clear ax */
	movw	%ax,%ds
	ldsw	4*0x41,%si
	movw	%cs,%ax			/* aka #SETUPSEG */
	subw	$DELTA_INITSEG,%ax	/* aka #INITSEG */
	pushw	%ax
	movw	%ax,%es
	movw	$0x0080,%di
	movw	$0x0010,%cx
	pushw	%cx
	cld
	rep
	movsb

/* Get hd1 data */

	xorw	%ax,%ax			/* clear ax */
	movw	%ax,%ds
	ldsw	4*0x46,%si
	popw	%cx
	popw	%es
	movw	$0x0090,%di
	rep
	movsb

/* Check that there IS a hd1 :-) */

	movw	$0x1500,%ax
	movb	$0x81,%dl
	int	$0x13
	jc	no_disk1
	cmpb	$3,%ah
	je	is_disk1
no_disk1:
	movw	%cs,%ax			/* aka #SETUPSEG */
	subw	$DELTA_INITSEG,%ax	/* aka #INITSEG */
	movw	%ax,%es
	movw	$0x0090,%di
	movw	$0x0010,%cx
	xorw	%ax,%ax			/* clear ax */
	cld
	rep
	stosb
is_disk1:

/* check for Micro Channel (MCA) bus */
	movw	%cs,%ax			/* aka #SETUPSEG */
	subw	$DELTA_INITSEG,%ax	/* aka #INITSEG */
	movw	%ax,%ds
     /* movw	%ax,%ds                   XXX Why twice ? */
	xorw	%ax,%ax
	movw	%ax,0x00a0		/* set table length to 0 */
	movb	$0xc0,%ah
	stc
	int	$0x15			/* puts feature table at es:bx */
	jc	no_mca
	pushw	%ds
	movw	%es,%ax
	movw	%ax,%ds
	movw	%cs,%ax			/* aka #SETUPSEG */
	subw	$DELTA_INITSEG,%ax	/* aka #INITSEG */
	movw	%ax,%es
	movw	%bx,%si
	movw	$0x00a0,%di
	movw	(%si),%cx
	addw	$2,%cx			/* table length is a short */
	cmpw	$0x10,%cx
	jc	sysdesc_ok
	movw	$0x10,%cx		/* we keep only first 16 bytes */
sysdesc_ok:
	rep
	movsb
	popw	%ds

no_mca:

/* Check for PS/2 pointing device */

	movw	%cs,%ax			/* aka #SETUPSEG */
	subw	$DELTA_INITSEG,%ax /* aka #INITSEG */
	movw	%ax,%ds
	movw	$0,0x01ff		/* default is no pointing device */ /* XXX byte or word ? */
	int	$0x11			/* int 0x11: equipment determination */
	testb	$0x04,%al		/* check if pointing device installed */
	jz	no_psmouse
	movw	$0xaa,0x01ff		/* device present */ /* XXX byte or word ? */
no_psmouse:

#ifdef CONFIG_APM
/* check for APM BIOS */
	/* NOTE: DS is pointing to the boot sector */
		
	movw	$0,64			/* version == 0 means no APM BIOS */

	movw	$0x5300,%ax		/* APM BIOS installation check */
	xorw	%bx,%bx
	int	$0x15
	jc	done_apm_bios		/* error -> no APM BIOS */

	cmpw	$0x504d,%bx		/* check for "PM" signature */
	jne	done_apm_bios		/* no signature -> no APM BIOS */

	andw	$0x02,%cx		/* Is 32 bit supported? */
	je	done_apm_bios		/*	no ... */

	movw	$0x5304,%ax		/* Disconnect first just in case */
	xorw	%bx,%bx
	int	$0x15			/* ignore return code */

	movw	$0x5303,%ax		/* 32 bit connect */
	xorw	%bx,%bx
	int	$0x15
	jc	no_32_apm_bios		/* error */

	movw	%ax,66			/* BIOS code segment */
	movl	%ebx,68			/* BIOS entry point offset */
	movw	%cx,72			/* BIOS 16 bit code segment */
	movw	%dx,74			/* BIOS data segment */
	movl	%esi,78			/* BIOS code segment length */
	movw	%di,82			/* BIOS data segment length */
/*
 * Redo the installation check as the 32 bit connect
 * modifies the flags returned on some BIOSs
 */
	movw	$0x5300,%ax		/* APM BIOS installation check */
	xorw	%bx,%bx
	int	$0x15
	jc	apm_disconnect		/* error -> should not happen, tidy up */

	cmpw	$0x504d,%bx		/* check for "PM" signature */
	jne	apm_disconnect		/* no signature -> should not happen, tidy up */

	movw	%ax,64			/* record the APM BIOS version */
	movw	%cx,76			/*	and flags */
	jmp	done_apm_bios

apm_disconnect:
	movw	$0x5304,%ax		/* Disconnect */
	xorw	%bx,%bx
	int	$0x15			/* ignore return code */
	jmp	done_apm_bios

no_32_apm_bios:
	andw	$0xfffd,76		/* remove 32 bit support bit */

done_apm_bios:
#endif

/* Now we want to move to protected mode ... */

	/* seg cs */
	cmpw	$0,%cs:realmode_swtch
	jz	rmodeswtch_normal
	/* seg cs */
	lcall	%cs:realmode_swtch
	jmp	rmodeswtch_end
rmodeswtch_normal:
        pushw	%cs
	call	default_switch
rmodeswtch_end:

/* we get the code32 start address and modify the below 'jmpi'
  (loader may have changed it) */
	/* seg cs */
	movl	%cs:code32_start,%eax
	/* seg cs */
	movl	%eax,%cs:code32

/* Now we move the system to its rightful place
  ...but we check, if we have a big-kernel.
  in this case we *must* not move it ... */
	/* seg cs */
	testb	$LOADED_HIGH,%cs:loadflags
	jz	do_move0		/* we have a normal low loaded zImage 
					   we have a high loaded big kernel */
	jmp	end_move		/* ... and we skip moving */

do_move0:
	movw	$0x0100,%ax		/* start of destination segment */
	movw	%cs,%bp			/* aka #SETUPSEG */
	subw	$DELTA_INITSEG,%bp	/* aka #INITSEG */
	/* seg cs */
	movw	%cs:start_sys_seg,%bx	/* start of source segment */
	cld				/* 'direction'=0, movs moves forward */
do_move:
	movw	%ax,%es			/* destination segment */
	incb	%ah			/* instead of add ax,#0x100 */
	movw	%bx,%ds			/* source segment */
	addw	$0x0100,%bx
	subw	%di,%di
	subw	%si,%si
	movw 	$0x0800,%cx
	rep
	movsw
	cmpw	%bp,%bx			/* we assume start_sys_seg > 0x200,
					   so we will perhaps read one page more then
					   needed, but never overwrite INITSEG because
					   destination is minimum one page below source */
	jb	do_move

/* then we load the segment descriptors */

end_move:
	movw	%cs,%ax			/* aka #SETUPSEG ! right, forgot this at first. didn't work :-) */
	movw	%ax,%ds

/* If we have our code not at 0x90000, we need to move it there now.
  We also then need to move the parameters behind it (command line)
  Because we would overwrite the code on the current IP, we move
  it in two steps, jumping high after the first one. */
	movw	%cs,%ax
	cmpw	$SETUPSEG,%ax
	je	end_move_self
	cli	/* make sure we really have interrupts disabled !
		   because after this the stack should not be used */
	subw	$DELTA_INITSEG,%ax	/* aka #INITSEG */
	movw	%ss,%dx
	cmpw	%ax,%dx
	jb	move_self_1
	addw	$INITSEG,%dx
	subw	%ax,%dx			/* this will be SS after the move */
move_self_1:
	movw	%ax,%ds
	movw	$INITSEG,%ax		/* real INITSEG */
	movw	%ax,%es
	/* seg cs */
	movw	%cs:setup_move_size,%cx
	std				/* we have to move up, so we use direction down
					   because the areas may overlap */
	movw	%cx,%di
	decw	%di
	movw	%di,%si
	subw	$move_self_here+0x200,%cx
	rep
	movsb
	ljmp	$SETUPSEG,$move_self_here	/* jump to our final place */
move_self_here:
	movw	$move_self_here+0x200,%cx
	rep
	movsb
	movw	$SETUPSEG,%ax
	movw	%ax,%ds
	movw	%dx,%ss
			/* now we are at the right place */
end_move_self:

	lidt	idt_48			/* load idt with 0,0 */
	lgdt	gdt_48			/* load gdt with whatever appropriate */

/* that was painless, now we enable A20 */

	call	empty_8042
	movb	$0xd1,%al		/* command write */
	outb	%al,$0x64
	call	empty_8042
	movb	$0xdf,%al		/* A20 on */
	outb	%al,$0x60
	call	empty_8042

/*  
 wait until a20 really *is* enabled; it can take a fair amount of
 time on certain systems; Toshiba Tecras are known to have this
 problem.  The memory location used here is the int 0x1f vector,
 which should be safe to use; any *unused* memory location < 0xfff0
 should work here.  
*/
	
#define	TEST_ADDR 0x7c

	pushw	%ds
	xorw	%ax,%ax			/* segment 0x0000 */
	movw	%ax,%ds
	decw	%ax			/* segment 0xffff (HMA) */
	movw	%ax,%gs
	movw	TEST_ADDR,%bx		/* we want to restore the value later */
a20_wait:
	incw	%ax
	movw	%ax,TEST_ADDR
	/* seg	gs */
	cmpw	%gs:TEST_ADDR+0x10,%ax
	je	a20_wait		/* loop until no longer aliased */
	movw	%bx,TEST_ADDR		/* restore original value */
	popw	%ds
		
/* make sure any possible coprocessor is properly reset.. */

	xorw	%ax,%ax
	outb	%al,$0xf0
	call	delay
	outb	%al,$0xf1
	call	delay

/* well, that went ok, I hope. Now we have to reprogram the interrupts :-(
   we put them right after the intel-reserved hardware interrupts, at
   int 0x20-0x2F. There they won't mess up anything. Sadly IBM really
   messed this up with the original PC, and they haven't been able to
   rectify it afterwards. Thus the bios puts interrupts at 0x08-0x0f, 
   which is used for the internal hardware interrupts as well. We just
   have to reprogram the 8259's, and it isn't fun. */

	movb	$0x11,%al		/* initialization sequence */
	outb	%al,$0x20		/* send it to 8259A-1 */
	call	delay
	outb	%al,$0xA0		/* and to 8259A-2 */
	call	delay
	movb	$0x20,%al		/* start of hardware int's (0x20) */
	outb	%al,$0x21
	call	delay
	movb	$0x28,%al		/* start of hardware int's 2 (0x28) */
	outb	%al,$0xa1
	call	delay
	movb	$0x04,%al		/* 8259-1 is master */
	outb	%al,$0x21
	call	delay
	movb	$0x02,%al		/* 8259-2 is slave */
	outb	%al,$0xa1
	call	delay
	movb	$0x01,%al		/* 8086 mode for both */
	outb	%al,$0x21
	call	delay
	outb	%al,$0xa1
	call	delay
	movb	$0xff,%al		/* mask off all interrupts for now */
	outb	%al,$0xa1
	call	delay
	movb	$0xfb,%al		/* mask all irq's but irq2 which
	outb	%al,$0x21		  is cascaded */

/*
  Well, that certainly wasn't fun :-(. Hopefully it works, and we don't
  need no steenking BIOS anyway (except for the initial loading :-).
  The BIOS routine wants lots of unnecessary data, and it's less
  "interesting" anyway. This is how REAL programmers do it.
 
  Well, now's the time to actually move into protected mode. To make
  things as simple as possible, we do no register set-up or anything,
  we let the GNU-compiled 32-bit programs do that. We just jump to
  absolute address 0x1000 (or the loader supplied one),
  in 32-bit protected mode.
 
  Note that the short jump isn't strictly needed, although there are
  reasons why it might be a good idea. It won't hurt in any case.
*/
	movw	$1,%ax			/* protected mode (PE) bit */
	lmsw	%ax			/* This is it! */
	jmp	flush_instr
flush_instr:
	xorw	%bx,%bx			/* Flag to indicate a boot */

/* NOTE: For high loaded big kernels we need a
 	ljmp    $__KERNEL_CS,$0x100000

	but we yet haven't reloaded the CS register, so the default size 
	of the target offset still is 16 bit.
	However, using an operant prefix (0x66), the CPU will properly
	take our 48 bit far pointer. (INTeL 80386 Programmer's Reference
	Manual, Mixing 16-bit and 32-bit code, page 16-6) */

	.byte	0x66,0xea		/* prefix + jmpi-opcode */
code32:	.long	0x1000			/* will be set to 0x100000 for big kernels */
	.word	__KERNEL_CS


kernel_version:	.ascii	UTS_RELEASE," (",LINUX_COMPILE_BY,"@",LINUX_COMPILE_HOST,") ",UTS_VERSION
		.byte 	0

/* This is the default real mode switch routine.
  to be called just before protected mode transition */

default_switch:
	cli				/* no interrupts allowed ! */
	movb	$0x80,%al		/* disable NMI for the bootup sequence */
	outb	%al,$0x70
	lret

/*
 * This routine only gets called, if we get loaded by the simple
 * bootsect loader _and_ have a bzImage to load.
 * Because there is no place left in the 512 bytes of the boot sector,
 * we must emigrate to code space here.
 */
bootsect_helper:
	/* seg cs */
	cmpw	$0,%cs:bootsect_es
	jnz	bootsect_second
	/* seg cs */
	movb	$0x20,%cs:type_of_loader
	movw	%es,%ax
	shrw	$4,%ax
	/* seg	cs */
	movb	%ah,%cs:bootsect_src_base+2
	movw	%es,%ax
	/* seg cs */
	movw	%ax,%cs:bootsect_es
	subw	$SYSSEG,%ax
	lret				/* nothing else to do for now */
bootsect_second:
	pushw	%cx
	pushw	%si
	pushw	%bx
	testw	%bx,%bx			/* 64K full ? */
	jne	bootsect_ex
	movw	$0x8000,%cx		/* full 64K move, INT 0x15 moves words */
	pushw	%cs
	popw	%es
	movw	$bootsect_gdt,%si
	movw	$0x8700,%ax
	int	$0x15
	jc	bootsect_panic		/* this, if INT 0x15 fails */
	/* seg cs */
	movw	%cs:bootsect_es,%es	/* we reset es to always point to 0x10000 */
	/* seg cs */
	incb	%cs:bootsect_dst_base+2
bootsect_ex:
	/* seg cs */
	movb	%cs:bootsect_dst_base+2,%ah
	shlb	$4,%ah			/* we now have the number of moved frames in ax */
	xorb	%al,%al
	popw	%bx
	popw	%si
	popw	%cx
	lret

bootsect_gdt:
	.word	0,0,0,0
	.word	0,0,0,0
bootsect_src:
	.word	0xffff
bootsect_src_base:
	.byte	0,0,1			/* base = 0x010000 */
	.byte	0x93			/* typbyte */
	.word	0			/* limit16,base24 =0 */
bootsect_dst:
	.word	0xffff
bootsect_dst_base:
	.byte	0,0,0x10		/* base = 0x100000 */
	.byte	0x93			/* typbyte */
	.word	0			/* limit16,base24 =0 */
	.word	0,0,0,0			/* BIOS CS */
	.word	0,0,0,0			/* BIOS DS */
bootsect_es:
	.word	0

bootsect_panic:
	pushw	%cs
	popw	%ds
	cld
	leaw	bootsect_panic_mess,%si
	call	prtstr
bootsect_panic_loop:
	jmp	bootsect_panic_loop
bootsect_panic_mess:
	.asciz	"INT 0x15 refuses to access high memory.  Giving up."


/* 
 * This routine checks that the keyboard command queue is empty
 * (after emptying the output buffers)
 * Some machines have delusions that the keyboard buffer is always full
 *  with no keyboard attached...
 */
empty_8042:
	pushw	%cx
	movw	$0xFFFF,%cx

empty_8042_loop:
	decw	%cx
	jz	empty_8042_end_loop

	call	delay
	inb	$0x64,%al		/* 8042 status port */
	testb	$1,%al			/* output buffer? */
	jz	no_output
	call	delay
	inb	$0x60,%al		/* read it */
	jmp	empty_8042_loop
no_output:
	testb	$2,%al			/* is input buffer full? */
	jnz	empty_8042_loop		/* yes - loop */
empty_8042_end_loop:
        popw	%cx
	retw

/*
 * Read the CMOS clock. Return the seconds in al
 */
gettime:
	pushw	%cx
	movb	$0x02,%ah
	int	$0x1a
	movb	%dh,%al			/* dh contains the seconds */
	andb	$0x0f,%al
	movb	%dh,%ah
	movb	$0x04,%cl
	shrb	%cl,%ah
	aad
	popw	%cx
	retw

/*
 * Delay is needed after doing I/O
 */
delay:
	jmp	delay_end		/* XXX Change from .word 0x00eb */ /* jmp $+2 */
	
delay_end:
	retw

/*
 * Descriptor tables
 */

gdt:
	.word	0,0,0,0			/* dummy */

	.word	0,0,0,0			/* unused */

	.word	0xFFFF			/* 4Gb - (0x100000*0x1000 = 4Gb) */
	.word	0x0000			/* base address=0 */
	.word	0x9A00			/* code read/exec */
	.word	0x00CF			/* granularity=4096, 386 (+5th nibble of limit) */
 
	.word	0xFFFF			/* 4Gb - (0x100000*0x1000 = 4Gb) */
	.word	0x0000			/* base address=0 */
	.word	0x9200			/* data read/write */
	.word	0x00CF			/* granularity=4096, 386 (+5th nibble of limit) */

idt_48:
	.word	0			/* idt limit=0 */
	.word	0,0			/* idt base=0L */

gdt_48:
	.word	0x800			/* gdt limit=2048, 256 GDT entries */
	.word	512+gdt,0x9		/* gdt base = 0X9xxxx */

/*
 * Include video setup & detection code
 */

#include "video.S"
	
/*
 * Setup signature -- must be last
 */

setup_sig1:	.word	SIG1
setup_sig2:	.word	SIG2

/*
 * After this point, there is some free space which is used by the video mode
 * handling code to store the temporary mode table (not used by the kernel).
 */

modelist:

#if 0  /* XXX What is for ? 
	  these symbol are not used */
.text
endtext:
.data
enddata:
.bss
endbss:
#endif

